<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\BiodataModel;
use App\Models\PendidikanModel;
use App\Models\AktivitasModel;

class Frontend extends BaseController
{
    public function index()
    {
        $biodataModel    = new BiodataModel();
        $pendidikanModel = new PendidikanModel();
        $aktivitasModel  = new AktivitasModel();

        $data['biodata']    = $biodataModel->first();
        $data['pendidikan'] = $pendidikanModel->orderBy('tahun_masuk', 'asc')->findAll();
        $data['aktivitas']  = $aktivitasModel->orderBy('tanggal', 'desc')->findAll(5);

        return view('frontend/home', $data);
    }
}
